/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.entities.model.physical.humanoid;

import com.badlogic.gdx.ai.msg.MessageDispatcher;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import technology.rocketjump.undermount.entities.components.EntityComponent;
import technology.rocketjump.undermount.entities.model.Entity;
import technology.rocketjump.undermount.entities.model.EntityType;
import technology.rocketjump.undermount.entities.model.physical.item.ItemEntityAttributes;
import technology.rocketjump.undermount.entities.model.physical.item.ItemType;
import technology.rocketjump.undermount.mapping.model.TiledMap;

public class InventoryComponent
implements EntityComponent {
    private Map<Long, Entity> inventoryItems = new HashMap<Long, Entity>();

    public void addItem(Entity item) {
        if (!item.getType().equals((Object)EntityType.ITEM)) {
            throw new AssertionError((Object)("Attempting to add non-item entity to " + this.getClass().getSimpleName()));
        }
        this.inventoryItems.put(item.getId(), item);
    }

    public Entity removeItem(Entity item) {
        return this.inventoryItems.remove(item.getId());
    }

    public Entity getItemByType(ItemType itemType) {
        for (Entity item : this.inventoryItems.values()) {
            ItemEntityAttributes attributes = (ItemEntityAttributes)item.getPhysicalEntityComponent().getAttributes();
            if (attributes.getItemType().getItemTypeId() != itemType.getItemTypeId()) continue;
            return item;
        }
        return null;
    }

    public Collection<Entity> getAllItems() {
        return this.inventoryItems.values();
    }

    @Override
    public EntityComponent clone(MessageDispatcher messageDispatcher, TiledMap tiledMap) {
        InventoryComponent cloned = new InventoryComponent();
        for (Entity item : this.getAllItems()) {
            cloned.addItem(item.clone(messageDispatcher, tiledMap));
        }
        return cloned;
    }
}

